#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <mpi.h>

#define TAG_READ  1
#define TAG_WRITE 2
#define TAG_DONE  3

typedef struct {
    int k;
    int v;
} pair_t;

int main(int argc, char *argv[]) {
    int rank, size;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    int N = atoi(argv[1]);
    if (N != size) {
        MPI_Finalize();
        return 0;
    }

    srand(time(NULL) + rank);

    /* procesul 0 deține structura globală */
    int max_vals[10] = {0};

    /* fiecare proces alege M */
    int M = rand() % 9 + 2;

    /* procesul 0 știe câte operații așteaptă */
    int total_ops = 0;
    MPI_Reduce(&M, &total_ops, 1, MPI_INT, MPI_SUM, 0, MPI_COMM_WORLD);

    /* procesele worker */
    if (rank != 0) {
        for (int i = 0; i < M; i++) {
            int k = rand() % 10 + 1;
            int v = rand() % 100000 + 1;

            printf("[Thread %d] a generat perechea (%d, %d)\n",
                   rank, k, v);
            fflush(stdout);

            /* cere valoarea curentă */
            MPI_Send(&k, 1, MPI_INT, 0, TAG_READ, MPI_COMM_WORLD);
            int old_max;
            MPI_Recv(&old_max, 1, MPI_INT, 0, TAG_READ, MPI_COMM_WORLD,
                     MPI_STATUS_IGNORE);

            sleep(1);

            pair_t p = {k, v};
            MPI_Send(&p, sizeof(pair_t), MPI_BYTE, 0, TAG_WRITE, MPI_COMM_WORLD);
        }

        MPI_Send(NULL, 0, MPI_INT, 0, TAG_DONE, MPI_COMM_WORLD);
    }
    /* procesul 0 */
    else {
        int finished = 0;

        while (finished < size - 1 || total_ops > 0) {
            MPI_Status status;

            MPI_Probe(MPI_ANY_SOURCE, MPI_ANY_TAG,
                      MPI_COMM_WORLD, &status);

            if (status.MPI_TAG == TAG_READ) {
                int k;
                MPI_Recv(&k, 1, MPI_INT,
                         status.MPI_SOURCE, TAG_READ,
                         MPI_COMM_WORLD, MPI_STATUS_IGNORE);

                int val = max_vals[k - 1];
                MPI_Send(&val, 1, MPI_INT,
                         status.MPI_SOURCE, TAG_READ,
                         MPI_COMM_WORLD);
            }
            else if (status.MPI_TAG == TAG_WRITE) {
                pair_t p;
                MPI_Recv(&p, sizeof(pair_t), MPI_BYTE,
                         status.MPI_SOURCE, TAG_WRITE,
                         MPI_COMM_WORLD, MPI_STATUS_IGNORE);

                if (p.v > max_vals[p.k - 1])
                    max_vals[p.k - 1] = p.v;

                total_ops--;
            }
            else if (status.MPI_TAG == TAG_DONE) {
                MPI_Recv(NULL, 0, MPI_INT,
                         status.MPI_SOURCE, TAG_DONE,
                         MPI_COMM_WORLD, MPI_STATUS_IGNORE);
                finished++;
            }
        }

        /* afișare finală */
        for (int i = 0; i < 10; i++) {
            printf("(%d, %d)", i + 1, max_vals[i]);
            if (i < 9) printf(", ");
        }
        printf("\n");
    }

    MPI_Finalize();
    return 0;
}
